<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RecentPostsMail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $posts;

    /**
     * Create a new message instance.
     */
    public function __construct($posts)
    {
        $this->posts = $posts;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('Welcome to NewsHunt – Your Top 5 Recent Posts')
            ->view('front_end.emails.recent-posts')
            ->with([
                'posts' => $this->posts,
            ]);
    }
}
